<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

require_once MAPLE_DIR.'/includes/pear/Net/IPv4.php';
require_once MAPLE_DIR.'/includes/pear/Net/UserAgent/Mobile.php';

/**
 * 携帯チェッククラス
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class MobileCheck
{
	var $_mobile_info;

	/**
	 * コンストラクター
	 *
	 * @access	public
	 */
	function MobileCheck() {
		$this->_mobile_info = null;
	}

	/**
	 * 携帯チェッククラスの唯一のインスタンスを返却
	 *
	 * @return	Object	MobileCheckクラスのインスタンス
	 * @access	public
	 **/
	function &getInstance()
	{
		static $instance;
		if ($instance === NULL) {
			$instance = new MobileCheck();
			$instance->_checkAgent();
		}
		return $instance;
	}

    /**
     * 携帯かどうか確認
     *
     * @return  bool
     * @access  public
     */
    function isMobile()
    {
    	$container =& DIContainerFactory::getContainer();
    	$session =& $container->getComponent("Session");
    	$reader_flag = intval($session->getParameter("_reader_flag"));
    	if ($reader_flag == _ON) {
    		return true;
    	} else {
	    	return Net_UserAgent_Mobile::isMobile();
    	}
    }

    /**
     * 携帯情報を取得
     *
     * @return  bool
     * @access  public
     */
    function getMobileInfo()
    {
    	return $this->_mobile_info;
    }

    /**
     * ユーザーエージェントチェック
     *
     * @access  private
     */
    function _checkAgent()
    {
		if (!$this->isMobile()) { return; }

		static $userAgent;
		if ($userAgent === NULL) {
			$userAgent = Net_UserAgent_Mobile::factory();
		}

        $container =& DIContainerFactory::getContainer();
        $getdata =& $container->getComponent("GetData");
    	$config =& $getdata->getParameter("config");

		//$configView =& $container->getComponent("configView");
    	//$config = $configView->getConfigByCatid(_SYS_CONF_MODID, _GENERAL_CONF_CATID);

		$session =& $container->getComponent("Session");
		$tel_id = $userAgent->getSerialNumber().$userAgent->getUID();
		$tel_id = !empty($tel_id) ? $userAgent->getUserAgent()." ".$tel_id : "";
		if (empty($tel_id)) {
			$tel_id = $session->getParameter("_mobile_tel_id");
		}

		$this->_mobile_info = array(
			"currier" => $userAgent->getCarrierLongName(),
			"user_agent" => $userAgent->getUserAgent(),
			"tel_id" => $tel_id,
			"utn" => $userAgent->isDoCoMo() ? " utn" : "",
			"model" => $userAgent->getModel(),
			"autologin" => ($config[0]['autologin_use']['conf_value'] == _AUTOLOGIN_OK ? _AUTOLOGIN_OK : _OFF)
		);
		$session->setParameter("_mobile_tel_id", $tel_id);

		if ($userAgent->isDoCoMo()) {
	    	if (empty($_SERVER["HTTP_REFERER"])) {
		    	$_SERVER["HTTP_REFERER"] = BASE_URL;
	    	}
		}

		/*
		 * IPチェック(調査日 2010.09.01)
		 */
		$mobile_ip["DoCoMo"] = array(
			//WEBアクセス時（iモードブラウザ）使用中
			"210.153.84.0/24", "210.136.161.0/24", "210.153.86.0/24", "124.146.174.0/24",
			//2009.09.01から2010.08.31までに追加されたもの
			"124.146.175.0/24",
			//2010年7月上旬に追加予定
			"202.229.176.0/24", "202.229.177.0/24", "202.229.178.0/24",
			//2011年2月に追加予定
			"202.229.179.0/24", "111.89.188.0/24",
			//2011年7月に追加予定
			"111.89.189.0/24", "111.89.190.0/24", "111.89.191.0/24",

			//WEBアクセス時（フルブラウザ）使用中
			"210.153.87.0/24",

			//メール送信時（インターネット⇒iモード対応携帯電話）使用中
			"203.138.180.0/24", "203.138.181.0/24",

			//メール受信時（iモード対応携帯電話⇒インターネット）
			"203.138.203.0/24"

		);
		$mobile_ip["EZWeb"] = array(
			//使用中
			"210.230.128.224/28", "121.111.227.160/27", "61.117.1.0/28", "219.108.158.0/27",
			"219.125.146.0/28", "61.117.2.32/29", "61.117.2.40/29", "219.108.158.40/29",
			"219.125.148.0/25", "222.5.63.0/25", "222.5.63.128/25", "222.5.62.128/25",
			"59.135.38.128/25", "219.108.157.0/25", "219.125.145.0/25", "121.111.231.0/25",
			"121.111.227.0/25", "118.152.214.192/26", "118.159.131.0/25", "118.159.133.0/25",
			"118.159.132.160/27",
			//2009.09.01から2010.08.31までに追加されたもの
			"111.86.142.0/26", "111.86.141.64/26", "111.86.141.128/26", "111.86.141.192/26",
			"118.159.133.192/26",
			// 2010年10月予定
			"111.86.143.192/27", "111.86.143.224/27", "111.86.147.0/27", "111.86.142.128/26",
			"111.86.142.192/26", "111.86.143.0/26",

			//廃止
			"61.117.0.128/25", "61.117.1.128/25", "218.222.1.0/25", "218.222.1.128/28",
			"218.222.1.160/28", "61.202.3.64/28", "219.125.148.160/27", "121.111.231.160/27",
			"219.125.148.192/27", "222.7.56.0/27", "222.7.56.32/27", "222.7.56.96/27",
			"222.7.56.128/27", "222.7.56.192/27", "222.7.56.224/27", "222.7.57.64/27",
			"222.7.57.96/27", "222.7.57.128/27", "222.7.57.160/27", "222.7.57.192/27",
			"222.7.57.224/27", "219.125.151.128/27", "219.125.151.160/27", "219.125.151.192/27",
			"222.7.57.32/27",

			//PCSVで使用中
			"222.15.68.192/26", "59.135.39.128/27", "118.152.214.160/27", "118.152.214.128/27",
			"222.1.136.96/27", "222.1.136.64/27", "59.128.128.0/20",

			//現在キャリアのHPに載っていないが過去に使用されていたので一様記述
			"210.169.40.0/24", "211.5.2.128/25", "222.7.57.0/24", "210.196.3.192/26",
			"211.5.7.0/24", "59.135.38.128/25", "210.196.5.192/26", "218.222.1.0/24",
			"61.117.0.0/24", "210.230.128.0/24", "61.117.1.0/24", "219.125.148.0/24",
			"210.230.141.192/26", "219.108.158.0/26", "61.117.2.0/26", "210.234.105.32/29",
			"210.251.1.192/26", "219.125.151.128/25", "210.234.108.64/26", "61.202.3.0/24",
			"210.251.2.0/27", "222.5.63.0/24", "211.5.1.0/24", "222.7.56.0/24"
		);
		$mobile_ip["Softbank"] = array(
			//Yahoo!ケータイにて使用中
			"123.108.237.0/27", "202.253.96.224/27", "210.146.7.192/26", "210.175.1.128/25",

			//PCサイトブラウザにて使用中
			"123.108.237.224/27", "202.253.96.0/27",

			//メール送信サーバ
			"123.108.236.0/24", "202.179.203.0/24", "202.179.203.0/24", "210.146.60.128/25",
			"210.169.171.0/24", "210.169.176.0/24", "210.175.1.128/25",

			//廃止
			"210.169.130.112/28", "210.228.189.0/24",
			"123.108.236.0/24", "202.179.204.0/24",
			"210.146.60.192/26", "210.151.9.128/26",
			"210.228.189.0/24", "211.8.159.128/25" ,
			"123.108.237.240/28", "202.253.96.0/28",

			//PCメールにて利用するIPアドレス帯域は未公開

			//Xシリーズ
			//Internet Explorer
			"123.108.237.240/28","202.253.96.0/28",

			//他のアプリケーション
			"219.73.128.0/17","117.46.128.0/17"

		);
		$mobile_ip["WILLCOM"] = array(
			//Webアクセス時 使用中
			"61.198.128.0/24", "61.198.129.0/24", "61.198.130.0/24", "61.198.131.0/24",
			"61.198.132.0/24", "61.198.133.0/24", "61.198.134.0/24", "61.198.135.0/24",
			"61.198.136.0/24", "61.198.137.0/24", "61.198.138.100/32", "61.198.138.101/32",
			"61.198.138.102/32", "61.198.138.103/32", "61.198.139.0/29", "61.198.139.128/27",
			"61.198.139.160/28", "61.198.140.0/24", "61.198.141.0/24", "61.198.142.0/24",
			"61.198.143.0/24", "61.198.160.0/24", "61.198.161.0/24", "61.198.162.0/24",
			"61.198.163.0/24", "61.198.164.0/24", "61.198.165.0/24", "61.198.166.0/24",
			"61.198.168.0/24", "61.198.169.0/24", "61.198.170.0/24", "61.198.171.0/24",
			"61.198.172.0/24", "61.198.173.0/24", "61.198.174.0/24", "61.198.175.0/24",
			"61.198.248.0/24", "61.198.249.0/24", "61.198.250.0/24", "61.198.251.0/24",
			"61.198.252.0/24", "61.198.253.0/24", "61.198.254.0/24", "61.198.255.0/24",
			"61.204.0.0/24", "61.204.2.0/24", "61.204.3.0/25", "61.204.3.128/25",
			"61.204.4.0/24", "61.204.5.0/24", "61.204.6.0/25", "61.204.6.128/25",
			"61.204.7.0/25", "61.204.92.0/24", "61.204.93.0/24", "61.204.94.0/24",
			"61.204.95.0/24", "125.28.0.0/24", "125.28.1.0/24",
			"125.28.15.0/24",
			"125.28.16.0/24", "125.28.17.0/24", "125.28.2.0/24", "125.28.3.0/24",
			"125.28.4.0/24", "125.28.5.0/24",
			"125.28.8.0/24", "210.168.246.0/24", "210.168.247.0/24", "210.169.92.0/24",
			"210.169.93.0/24", "210.169.94.0/24", "210.169.95.0/24", "210.169.96.0/24",
			"210.169.97.0/24", "210.169.98.0/24", "210.169.99.0/24", "211.126.192.128/25",
			"211.18.232.0/24", "211.18.233.0/24", "211.18.234.0/24", "211.18.235.0/24",
			"211.18.236.0/24", "211.18.237.0/24",
			"219.108.10.0/24", "219.108.11.0/24", "219.108.12.0/24", "219.108.13.0/24",
			"219.108.14.0/24", "219.108.15.0/24",
			"219.108.7.0/24", "219.108.8.0/24", "219.108.9.0/24",
			"221.119.0.0/24", "221.119.1.0/24", "221.119.2.0/24", "221.119.3.0/24",
			"221.119.4.0/24", "221.119.6.0/24", "221.119.7.0/24",
			"221.119.8.0/24", "221.119.9.0/24",
			//追加IPアドレス帯域（2009年12月24日追加分）
			"114.20.49.0/24", "114.20.50.0/24", "114.20.51.0/24", "114.20.52.0/24",
			"114.20.53.0/24", "114.20.54.0/24", "114.20.55.0/24", "114.20.56.0/24",
			"114.20.57.0/24", "114.20.58.0/24", "114.20.59.0/24", "114.20.60.0/24",
			"114.20.61.0/24", "114.20.62.0/24", "114.20.63.0/24", "114.20.64.0/24",
			"114.20.65.0/24", "114.20.66.0/24", "114.20.67.0/24", "114.21.255.0/27",

			//廃止
			"219.108.2.0/24","219.108.3.0/24",
			"125.28.6.0/24", "125.28.7.0/24", "125.28.11.0/24", "125.28.12.0/24",
			"125.28.13.0/24", "125.28.14.0/24", "211.18.238.0/24", "211.18.239.0/24",
			"219.108.4.0/24", "219.108.5.0/24", "219.108.6.0/24", "221.119.5.0/24",

			//Eメール利用時
			"124.211.23.0/26"
		);

		$this->_mobile_info["ip_address"] = $_SERVER['REMOTE_ADDR'];
		$this->_mobile_info["ip_addr_zone"] = "";
		$this->_mobile_info["proper_route"] = _OFF;
		foreach ($mobile_ip as $key=>$ip_list) {
			foreach ($ip_list as $zone) {
				$valid = Net_IPv4::ipInNetwork($this->_mobile_info["ip_address"], $zone);
				if ($valid) {
					$this->_mobile_info["ip_addr_zone"] = $zone;
					$this->_mobile_info["proper_route"] = _ON;
					break;
				}
			}
			if ($valid) { break; }
		}

		if (empty($this->_mobile_info['proper_route'])) {
			$this->_mobile_info['autologin'] = _OFF;
		}
    }
}
?>
